#version 330
#extension GL_EXT_gpu_shader4 : enable
// molten fractalMod01.fsh by  jblanper

//https://www.shadertoy.com/view/wtsSDj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float tt;

mat2 rotate(float a) {
  return mat2(cos(a), -sin(a), sin(a), cos(a));
}

float smin( float a, float b, float k ) {
  float h = max( k-abs(a-b), 0.0 )/k;
  return min( a, b ) - h*h*h*k*(1.0/6.0);
}

float sphereSDF (vec3 p, vec3 c, float r) {
  return length(c - p) - r;
}

float cubeSDF (vec3 p, vec3 c, vec3 dimensions, float borderRoundness) {
  vec3 pos = abs(c - p) - dimensions;
  return length(max(pos, 0.)) - borderRoundness + min(max(pos.x, max(pos.y, pos.z)), 0.);
}

vec2 map (vec3 p) {
  //fractal
  for (int i=0; i<3; i++) {
    p = abs(p) - vec3(4., 3., 5.);

    p.xz *= rotate(sin(tt) * .5 + .6);
    p.yz *= rotate(cos(tt) * .5 + .8);
    p.xy *= rotate(cos(tt) * .5 + 2.);
    p += length(p.yx * sin(tt) * .2 + .4) * .5;
  }

  p *= .9; // to scale fractal .4

  // primitives
  float c1 = cubeSDF(abs(p) - vec3(length(p.yz) + .2, .1, .8), vec3(0.), vec3(.5, .2, .8), .05);
  c1 += sin(p.x * 4.) * cos(p.y * 6. + sin(tt)) * sin(p.z * 3.) * .3;
  float c2 = cubeSDF(abs(p) - vec3(.5, .3, 2.), vec3(0.), vec3(.3, .1, .6), .01);

  vec2 t = vec2(smin(c1 * .3, c2 * .15, .5), 2.);
  vec2 h = vec2(cubeSDF(abs(p) - vec3(.5, .2, .8), vec3(1.), vec3(.3, .3, .5), .03) * .3, .1);
  t = (t.x < h.x) ? t : h; // merge materials

  return t / .8;
}

vec2 trace (vec3 ro, vec3 rd) {
  const float MAX_DEPTH = 50.;
  vec2 h, t = vec2(.1);

  for (int i = 0; i < 48; i++) {
    h = map(ro + rd * t.x);
    if (h.x < .0001 || t.x > MAX_DEPTH) break;
    t.x += h.x; t.y = h.y;
  }
  if (t.x > MAX_DEPTH) t.x = 0.;
  return t;
}

vec3 getNormal (vec3 p) {
  float d = map(p).x;
  vec2 e = vec2(.01, 0.);

  return normalize(d - vec3(
    map(p - e.xyy).x,
    // 0.,
    map(p - e.yxy).x,
    map(p - e.yyx).x));
}

struct Material {
  float ambient;
  float diffuse;
  float specular;
};

float getLight (vec3 lightPos, vec3 p, vec3 rd, float lightOcclusion, Material material) {
  // https://www.shadertoy.com/view/ll2GW1
  vec3 light = normalize(lightPos - p);
  vec3 normal = getNormal(p);

  // phong reflection
  float ambient = clamp(.5 + .5 * normal.y, 0., 1.);
  float diffuse = clamp(dot(normal, light), 0., 1.);
  vec3 half_way = normalize(-rd + light);
  float specular = pow(clamp(dot(half_way, normal), 0.0, 1.0), 16.);

  return (ambient * material.ambient * lightOcclusion) +
   (diffuse * material.diffuse * lightOcclusion) +
   (diffuse * specular * material.specular * lightOcclusion);
}

vec3 getRayDirection (vec2 uv, vec3 rayOrigin, vec3 lookat, float zoom) {
  // https://www.youtube.com/watch?v=PBxuVlp7nuM
  vec3 forward = normalize(lookat - rayOrigin);
  vec3 right = normalize(cross(vec3(0., 1., 0.), forward));
  vec3 up = cross(forward, right);
  vec3 center = rayOrigin + forward * zoom;
  vec3 intersection = center + uv.x * right + uv.y * up;
  return normalize(intersection - rayOrigin);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
  vec2 uv = (gl_FragCoord.xy / iResolution.xy) * 2.0 - 1.0;
  uv.x *= iResolution.x / iResolution.y;
  tt = mod(iTime * .1, 100.);

  // camera
  vec3 ro = vec3(0., 0., 25. + sin(tt) * 10.);
  vec3 rd = getRayDirection(uv, ro, vec3(0.), 2.);

  // color, fog and light direction
  //vec3 ld = normalize(vec3(.5, .8, .5));
  vec3 ld = vec3(5., 8., 3.);
  vec3 fog = vec3(.01) * (.5 + (length(uv) - .3));
  vec3 color = fog;

  // scene
  vec2 sc = trace(ro, rd);
  float t = sc.x;

  if (t > 0.) {
    vec3 p = ro + rd * t;
    vec3 normal = getNormal(p);
    vec3 albido = vec3(.5);//base color

    if (sc.y > .9) {
      albido = vec3(2.);
    }

    // lightning
    ld.xz *= rotate(tt * 5.);
    color = getLight(ld, p, rd, .8, Material(.2, .7, 1.2)) * albido;
    color = mix(color, fog, 1. - exp(-.00007*t*t*t)); //gradient
  }

  gl_FragColor = vec4(pow(color, vec3(.45)), 1.);
}